import numpy as np
from math import *
import define_experiment as exp
import scipy.interpolate as sci
import subfunctions as sf
import matplotlib.pyplot as plt

rover = {'wheel_assembly': {'wheel': {'radius': 0.3, 'mass': 1},
                            'speed_reducer': {'type': 'reverted', 'diam_pinion': 0.05, 'diam_gear': 0.08, 'mass': 1.50},
                            'motor': {'torque_stall': 175, 'torque_noload': 0, 'speed_noload': 3.9, 'mass': 5,
                                      'effcy_tau': np.array([0, 10, 20, 40, 70, 165]),
                                      'effcy': np.array([0, 0.55, 0.75, 0.71, 0.5, 0.05])}},
         'chassis': {'mass': 659}, 'science_payload': {'mass': 75}, 'power_subsys': {'mass': 90}, 'telemetry': {}}
planet = {'g': 3.72}
experiment1 = exp.experiment1()
experiment = experiment1[0]
end_event = experiment1[1]

telemetry = sf.simulate_rover(rover, planet, experiment, end_event)['telemetry']
time = telemetry['Time']
position = telemetry['position']
velocity = telemetry['velocity']
power = telemetry['power']

figure, axis = plt.subplots(3)
axis[0].plot(time, position)
axis[0].set_title('Position vs Time')
axis[0].set_xlabel('Time (s)')
axis[0].set_ylabel('Position (m)')

axis[1].plot(time, velocity)
axis[1].set_title('Velocity vs Time')
axis[1].set_xlabel('Time (s)')
axis[1].set_ylabel('Velocity (m/s)')

axis[2].plot(time, power)
axis[2].set_title('Power vs Time')
axis[2].set_xlabel('Time (s)')
axis[2].set_ylabel('Power (W)')
figure.tight_layout(pad=1.5)    #This is to increase the space between the graphs
plt.show()
